<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFieldPermissionTable extends Migration {

	public function up()
	{
		Schema::create('field_permission', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('table_name', 255);
			$table->string('field_name', 255);
			$table->string('parent_table', 255)->nullable();
			$table->string('parent_text')->nullable();
			$table->string('parent_id')->nullable();
			$table->integer('multi_lang')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('field_permission');
	}
}