<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Marriages', function(Blueprint $table) {
			$table->foreign('deceased_id')->references('id')->on('Deceased')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Children', function(Blueprint $table) {
			$table->foreign('deceased_id')->references('id')->on('Deceased')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Relationships', function(Blueprint $table) {
			$table->foreign('deceased_id')->references('id')->on('Deceased')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Defacto', function(Blueprint $table) {
			$table->foreign('deceased_id')->references('id')->on('Deceased')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Marriages', function(Blueprint $table) {
			$table->dropForeign('Marriages_deceased_id_foreign');
		});
		Schema::table('Children', function(Blueprint $table) {
			$table->dropForeign('Children_deceased_id_foreign');
		});
		Schema::table('Relationships', function(Blueprint $table) {
			$table->dropForeign('Relationships_deceased_id_foreign');
		});
		Schema::table('Defacto', function(Blueprint $table) {
			$table->dropForeign('Defacto_deceased_id_foreign');
		});
	}
}