<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('tree_id')->references('id')->on('trees')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('sub_accounts', function(Blueprint $table) {
			$table->foreign('account_id')->references('id')->on('accounts')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('partiner_bonds', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('partners')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('partiner_bond_items', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('supply_bond_items', function(Blueprint $table) {
			$table->foreign('bond_id')->references('id')->on('supply_bond')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('supply_bond_items', function(Blueprint $table) {
			$table->foreign('kind_id')->references('id')->on('kinds')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('supply_bond_items', function(Blueprint $table) {
			$table->foreign('karat_id')->references('id')->on('karats')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('supply_bond_items', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('supply_bond_items')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('nationality')->references('id')->on('nationalities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('diamond_bond_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('diamond_bond_items', function(Blueprint $table) {
			$table->foreign('carat_id')->references('id')->on('karats')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('diamond_bond_items', function(Blueprint $table) {
			$table->foreign('bond_id')->references('id')->on('supply_bond')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('accessory_bond_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('accessory_bond_items', function(Blueprint $table) {
			$table->foreign('carat_id')->references('id')->on('karats')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('accessory_bond_items', function(Blueprint $table) {
			$table->foreign('bond_id')->references('id')->on('supply_bond')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('supply_bond_payment', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('branches')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('market_id')->references('id')->on('markets')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->foreign('national_id')->references('id')->on('nationalities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cards', function(Blueprint $table) {
			$table->foreign('card_type_id')->references('id')->on('card_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cards', function(Blueprint $table) {
			$table->foreign('banck_id')->references('id')->on('banks')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cards', function(Blueprint $table) {
			$table->foreign('banck_account_id')->references('id')->on('banck_accounts')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('size_units', function(Blueprint $table) {
			$table->foreign('size_id')->references('id')->on('sizes')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_tree_id_foreign');
		});
		Schema::table('sub_accounts', function(Blueprint $table) {
			$table->dropForeign('sub_accounts_account_id_foreign');
		});
		Schema::table('partiner_bonds', function(Blueprint $table) {
			$table->dropForeign('partiner_bonds_parent_id_foreign');
		});
		Schema::table('partiner_bond_items', function(Blueprint $table) {
			$table->dropForeign('partiner_bond_items_unit_id_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_country_id_foreign');
		});
		Schema::table('suppliers', function(Blueprint $table) {
			$table->dropForeign('suppliers_city_id_foreign');
		});
		Schema::table('supply_bond_items', function(Blueprint $table) {
			$table->dropForeign('supply_bond_items_bond_id_foreign');
		});
		Schema::table('supply_bond_items', function(Blueprint $table) {
			$table->dropForeign('supply_bond_items_kind_id_foreign');
		});
		Schema::table('supply_bond_items', function(Blueprint $table) {
			$table->dropForeign('supply_bond_items_karat_id_foreign');
		});
		Schema::table('supply_bond_items', function(Blueprint $table) {
			$table->dropForeign('supply_bond_items_parent_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_nationality_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_branch_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_city_id_foreign');
		});
		Schema::table('diamond_bond_items', function(Blueprint $table) {
			$table->dropForeign('diamond_bond_items_product_id_foreign');
		});
		Schema::table('diamond_bond_items', function(Blueprint $table) {
			$table->dropForeign('diamond_bond_items_carat_id_foreign');
		});
		Schema::table('diamond_bond_items', function(Blueprint $table) {
			$table->dropForeign('diamond_bond_items_bond_id_foreign');
		});
		Schema::table('accessory_bond_items', function(Blueprint $table) {
			$table->dropForeign('accessory_bond_items_product_id_foreign');
		});
		Schema::table('accessory_bond_items', function(Blueprint $table) {
			$table->dropForeign('accessory_bond_items_carat_id_foreign');
		});
		Schema::table('accessory_bond_items', function(Blueprint $table) {
			$table->dropForeign('accessory_bond_items_bond_id_foreign');
		});
		Schema::table('supply_bond_payment', function(Blueprint $table) {
			$table->dropForeign('supply_bond_payment_supplier_id_foreign');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_parent_id_foreign');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_market_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_country_id_foreign');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->dropForeign('banks_country_id_foreign');
		});
		Schema::table('banks', function(Blueprint $table) {
			$table->dropForeign('banks_city_id_foreign');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->dropForeign('partners_city_id_foreign');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->dropForeign('partners_national_id_foreign');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->dropForeign('partners_country_id_foreign');
		});
		Schema::table('cards', function(Blueprint $table) {
			$table->dropForeign('cards_card_type_id_foreign');
		});
		Schema::table('cards', function(Blueprint $table) {
			$table->dropForeign('cards_banck_id_foreign');
		});
		Schema::table('cards', function(Blueprint $table) {
			$table->dropForeign('cards_banck_account_id_foreign');
		});
		Schema::table('size_units', function(Blueprint $table) {
			$table->dropForeign('size_units_size_id_foreign');
		});
	}
}