<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReturnedBondsTable extends Migration {

	public function up()
	{
		Schema::create('returned_bonds', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('bond_id');
			$table->enum('bond_type', array('gold', 'diamond', 'accessory'));
			$table->date('bond_date');
			$table->string('bond_number');
			$table->integer('supplier_id');
			$table->double('gold_price');
			$table->double('entity_gold_price');
			$table->text('notes');
			$table->softDeletes();
			$table->timestamps();
			$table->double('total_gold_24');
			$table->integer('count_item');
			$table->double('total_tax');
			$table->double('bond_total_value');
		});
	}

	public function down()
	{
		Schema::drop('returned_bonds');
	}
}