<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePartnersTable extends Migration {

	public function up()
	{
		Schema::create('partners', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('username');
			$table->string('name');
			$table->bigInteger('city_id')->unsigned()->index();
			$table->string('email')->unique();
			$table->string('phone');
			$table->bigInteger('national_id')->unsigned()->index();
			$table->bigInteger('country_id')->unsigned()->index();
			$table->date('national_expir_date')->nullable();
			$table->string('national_image');
			$table->date('partnership_start_date')->nullable();
			$table->integer('partnership_rate');
		});
	}

	public function down()
	{
		Schema::drop('partners');
	}
}