<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemStoneTable extends Migration {

	public function up()
	{
		Schema::create('item_stone', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('item_id');
			$table->integer('stone_id');
			$table->boolean('weight_status');
			$table->integer('color_id');
			$table->integer('shape_id');
			$table->integer('purity_id');
			$table->double('stone_weight');
			$table->integer('stone_count');
			$table->enum('stone_nature', array('a', 'b', 'c'));
			$table->string('certificate_number');
			$table->string('certificate');
			$table->string('certificate_source');
		});
	}

	public function down()
	{
		Schema::drop('item_stone');
	}
}