<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountBondsTable extends Migration {

	public function up()
	{
		Schema::create('discount_bonds', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->date('bond_date');
			$table->integer('supplier_id');
			$table->integer('bond_id');
			$table->string('bond_number');
			$table->string('bond_docs');
			$table->text('notes')->nullable();
			$table->double('value');
			$table->json('unit');
		});
	}

	public function down()
	{
		Schema::drop('discount_bonds');
	}
}