<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('national_id');
			$table->string('email')->nullable();
			$table->bigInteger('country_id')->unsigned()->index();
			$table->string('phone')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}