<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTreesTable extends Migration {

	public function up()
	{
		Schema::create('trees', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar')->index();
			$table->string('name_en', 255)->nullable()->index();
			$table->integer('numeric_system')->unique();
			$table->enum('type', array('a', 'b', 'c', 'd'));
			$table->json('units');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('trees');
	}
}