<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiamondBondItemsTable extends Migration {

	public function up()
	{
		Schema::create('diamond_bond_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('product_id')->unsigned();
			$table->double('weight')->nullable();
			$table->double('gold_weight')->nullable();
			$table->bigInteger('carat_id')->unsigned();
			$table->double('diamond_value')->nullable();
			$table->string('diamond_count')->nullable();
			$table->double('diamond_stone_weight')->nullable();
			$table->double('diamond_tax');
			$table->double('discount')->nullable();
			$table->double('other_stones_weight')->nullable();
			$table->longText('notes')->nullable();
			$table->integer('bond_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('diamond_bond_items');
	}
}