<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchesTable extends Migration {

	public function up()
	{
		Schema::create('branches', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('parent_id')->unsigned();
			$table->bigInteger('market_id')->unsigned()->index();
			$table->string('name_en')->nullable();
			$table->string('name_ar');
			$table->string('market_number')->nullable();
			$table->string('latitude');
			$table->string('longitude')->nullable();
			$table->string('phone')->nullable();
			$table->string('footer_format_ar')->nullable();
			$table->string('footer_format_en')->nullable();
			$table->string('address')->nullable();
			$table->string('building_number')->nullable();
			$table->string('sub_number')->nullable();
			$table->string('district')->nullable();
			$table->string('city_id');
		});
	}

	public function down()
	{
		Schema::drop('branches');
	}
}