<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('purchase_id')->unsigned();
			$table->integer('billingcycle_id')->unsigned();
			$table->decimal('invoice_amount');
			$table->integer('tax_rate');
			$table->decimal('final_invoice_amount');
			$table->decimal('uncleared_amount');
			$table->date('invoice_date');
			$table->date('collection_date');
			$table->datetime('created_at');
			$table->datetime('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}