<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->string('order_id', 15)->unique();
			$table->mediumInteger('union_id');
			$table->mediumInteger('customer_id');
			$table->double('order_amount');
			$table->enum('status', array('pending', 'confirmed', 'rejected'));
			$table->bigInteger('created_by');
			$table->timestamps();
			$table->string('created_by_ip', 15);
			$table->bigInteger('updated_by')->nullable();
			$table->string('updated_by_ip', 15)->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}