<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Tag extends Model 
{

    protected $table = 'tags';
    public $timestamps = true;
    protected $fillable = array('name');

    public function posts()
    {
        return $this->belongsToMany('App\Post');
    }

    public function comments()
    {
        return $this->morphMany('App\Comment', 'commentable');
    }

}