<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->foreign('employee_id')->references('employee_id')->on('employee')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('enterpriseHeadquarter', function(Blueprint $table) {
			$table->foreign('city_id')->references('city_id')->on('city')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('enterpriseHeadquarter', function(Blueprint $table) {
			$table->foreign('enterprise_id')->references('enterprise_id')->on('enterprise')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('planningTurn', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('planningTurn', function(Blueprint $table) {
			$table->foreign('planning_id')->references('planning_id')->on('planning')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('planningTurn', function(Blueprint $table) {
			$table->foreign('turn_id')->references('turn_id')->on('turn')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('turnActivity', function(Blueprint $table) {
			$table->foreign('turn_id')->references('turn_id')->on('turn')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('turnActivity', function(Blueprint $table) {
			$table->foreign('activity_id')->references('activity_id')->on('activity')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('enterpriseheadquarter_id')->references('enterpriseheadquarter_id')->on('enterpriseHeadquarter')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('enterprise_id')->references('enterprise_id')->on('enterprise')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('activityEmployee', function(Blueprint $table) {
			$table->foreign('activity_id')->references('activity_id')->on('activity')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('activityEmployee', function(Blueprint $table) {
			$table->foreign('employee_id')->references('employee_id')->on('employee')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('turnEmployee', function(Blueprint $table) {
			$table->foreign('turn_id')->references('turn_id')->on('turn')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('turnEmployee', function(Blueprint $table) {
			$table->foreign('employee_id')->references('employee_id')->on('employee')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('activityObservations', function(Blueprint $table) {
			$table->foreign('turnactivity_id')->references('turnactivity_id')->on('turnActivity')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('planning', function(Blueprint $table) {
			$table->foreign('enterpriseheadquarter_id')->references('enterpriseheadquarter_id')->on('enterpriseHeadquarter')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('assistance', function(Blueprint $table) {
			$table->foreign('turnemployee_id')->references('turnemployee_id')->on('turnEmployee')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('turnObservations', function(Blueprint $table) {
			$table->foreign('planningturn_id')->references('planingturn_id')->on('planningTurn')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('enterpriseEnterpriseUnit', function(Blueprint $table) {
			$table->foreign('enterprise_id')->references('enterprise_id')->on('enterprise')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('enterpriseEnterpriseUnit', function(Blueprint $table) {
			$table->foreign('emterpirseunit_id')->references('enterpriseunit_id')->on('enterpriseUnit')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->dropForeign('user_employee_id_foreign');
		});
		Schema::table('enterpriseHeadquarter', function(Blueprint $table) {
			$table->dropForeign('enterpriseHeadquarter_city_id_foreign');
		});
		Schema::table('enterpriseHeadquarter', function(Blueprint $table) {
			$table->dropForeign('enterpriseHeadquarter_enterprise_id_foreign');
		});
		Schema::table('planningTurn', function(Blueprint $table) {
			$table->dropForeign('planningTurn_user_id_foreign');
		});
		Schema::table('planningTurn', function(Blueprint $table) {
			$table->dropForeign('planningTurn_planning_id_foreign');
		});
		Schema::table('planningTurn', function(Blueprint $table) {
			$table->dropForeign('planningTurn_turn_id_foreign');
		});
		Schema::table('turnActivity', function(Blueprint $table) {
			$table->dropForeign('turnActivity_turn_id_foreign');
		});
		Schema::table('turnActivity', function(Blueprint $table) {
			$table->dropForeign('turnActivity_activity_id_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_enterpriseheadquarter_id_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_enterprise_id_foreign');
		});
		Schema::table('activityEmployee', function(Blueprint $table) {
			$table->dropForeign('activityEmployee_activity_id_foreign');
		});
		Schema::table('activityEmployee', function(Blueprint $table) {
			$table->dropForeign('activityEmployee_employee_id_foreign');
		});
		Schema::table('turnEmployee', function(Blueprint $table) {
			$table->dropForeign('turnEmployee_turn_id_foreign');
		});
		Schema::table('turnEmployee', function(Blueprint $table) {
			$table->dropForeign('turnEmployee_employee_id_foreign');
		});
		Schema::table('activityObservations', function(Blueprint $table) {
			$table->dropForeign('activityObservations_turnactivity_id_foreign');
		});
		Schema::table('planning', function(Blueprint $table) {
			$table->dropForeign('planning_enterpriseheadquarter_id_foreign');
		});
		Schema::table('assistance', function(Blueprint $table) {
			$table->dropForeign('assistance_turnemployee_id_foreign');
		});
		Schema::table('turnObservations', function(Blueprint $table) {
			$table->dropForeign('turnObservations_planningturn_id_foreign');
		});
		Schema::table('enterpriseEnterpriseUnit', function(Blueprint $table) {
			$table->dropForeign('enterpriseEnterpriseUnit_enterprise_id_foreign');
		});
		Schema::table('enterpriseEnterpriseUnit', function(Blueprint $table) {
			$table->dropForeign('enterpriseEnterpriseUnit_emterpirseunit_id_foreign');
		});
	}
}