<?php

namespace App;

class TurnEmployee extends Eloquent {

	protected $table = 'turnEmployee';
	public $timestamps = true;
	protected $guarded = array('turnemployee_id');
	protected $fillable = array('beginDateTime', 'endDateTime', 'turn_id', 'employee_id');

	public function getTurn()
	{
		return $this->hasMany('App\Turn', 'turn_id');
	}

	public function getEmployee()
	{
		return $this->hasMany('App\Employee', 'employee_id');
	}

	public function getAssistance()
	{
		return $this->hasOne('App\Assistance', 'assistance_id');
	}

}