<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class PlanningTurn extends Model 
{

    protected $table = 'planningTurn';
    public $timestamps = true;
    protected $guarded = array('planingturn_id', 'timestamps');
    protected $fillable = array('beginDateTime', 'endDateTime', 'user_id', 'planning_id', 'turn_id');

    public function getSupervisor()
    {
        return $this->hasOne('App\User', 'user_id');
    }

    public function getPlanning()
    {
        return $this->hasOne('App\Planning', 'planning_id');
    }

}