<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lesson extends Eloquent {

	protected $table = 'lessons';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function lessonable()
	{
		return $this->morphTo();
	}

	public function parts()
	{
		return $this->belongsToMany('LessonParts', 'lesson_parts_map')->withPivot('order');
	}

}