<?php

namespace Saving;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Saving extends Model 
{

    protected $table = 'savings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function savingHasOnePayroll()
    {
        return $this->hasMany('Payroll', 'payroll_id');
    }

    public function savingHasManySavingProduct()
    {
        return $this->hasMany('SavingProduct', 'saving_product_id');
    }

}