<?php

namespace EmployeeGroup;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeGroup extends Model 
{

    protected $table = 'employee_group';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function employeeGroupHasManyGroup()
    {
        return $this->hasMany('Group');
    }

    public function employeeGroupBelongsToEmployee()
    {
        return $this->belongsTo('Employees');
    }

}