<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('EmailNotifications', function(Blueprint $table) {
			$table->foreign('milestone_id')->references('id')->on('Milestones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Projects', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Selections', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Selections', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('Projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Contracts', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Contracts', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('Plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MonthlyPayments', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('Contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('SettingsList', function(Blueprint $table) {
			$table->foreign('plan')->references('id')->on('Plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('SettingsList', function(Blueprint $table) {
			$table->foreign('setting')->references('id')->on('Settings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ProfilesList', function(Blueprint $table) {
			$table->foreign('profile')->references('id')->on('Profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ProfilesList', function(Blueprint $table) {
			$table->foreign('plan')->references('id')->on('Plans')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Milestones', function(Blueprint $table) {
			$table->foreign('selection_id')->references('id')->on('Selections')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Milestones', function(Blueprint $table) {
			$table->foreign('requirement_id')->references('id')->on('Requirements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ControlEmailNotifications', function(Blueprint $table) {
			$table->foreign('emailNotification_id')->references('id')->on('EmailNotifications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('EmailNotifications', function(Blueprint $table) {
			$table->dropForeign('EmailNotifications_milestone_id_foreign');
		});
		Schema::table('Projects', function(Blueprint $table) {
			$table->dropForeign('Projects_client_id_foreign');
		});
		Schema::table('Selections', function(Blueprint $table) {
			$table->dropForeign('Selections_created_by_foreign');
		});
		Schema::table('Selections', function(Blueprint $table) {
			$table->dropForeign('Selections_project_id_foreign');
		});
		Schema::table('Contracts', function(Blueprint $table) {
			$table->dropForeign('Contracts_customer_id_foreign');
		});
		Schema::table('Contracts', function(Blueprint $table) {
			$table->dropForeign('Contracts_plan_id_foreign');
		});
		Schema::table('MonthlyPayments', function(Blueprint $table) {
			$table->dropForeign('MonthlyPayments_contract_id_foreign');
		});
		Schema::table('SettingsList', function(Blueprint $table) {
			$table->dropForeign('SettingsList_plan_foreign');
		});
		Schema::table('SettingsList', function(Blueprint $table) {
			$table->dropForeign('SettingsList_setting_foreign');
		});
		Schema::table('ProfilesList', function(Blueprint $table) {
			$table->dropForeign('ProfilesList_profile_foreign');
		});
		Schema::table('ProfilesList', function(Blueprint $table) {
			$table->dropForeign('ProfilesList_plan_foreign');
		});
		Schema::table('Milestones', function(Blueprint $table) {
			$table->dropForeign('Milestones_selection_id_foreign');
		});
		Schema::table('Milestones', function(Blueprint $table) {
			$table->dropForeign('Milestones_requirement_id_foreign');
		});
		Schema::table('ControlEmailNotifications', function(Blueprint $table) {
			$table->dropForeign('ControlEmailNotifications_emailNotification_id_foreign');
		});
	}
}