<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('Profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 20);
			$table->string('description', 50)->nullable();
			$table->json('adminPermissions');
			$table->json('customerPermissions');
			$table->enum('status', array(''));
		});
	}

	public function down()
	{
		Schema::drop('Profiles');
	}
}