<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Challenge extends Model 
{

    protected $table = 'challenges';
    public $timestamps = true;
    protected $fillable = array('description', 'start_date', 'end_date', 'winner_number');

    public function freelancers()
    {
        return $this->belongsToMany('Freelancer', 'ChallengeFreelancer');
    }

    public function project()
    {
        return $this->belongsTo('\Project');
    }

    public function criterions()
    {
        return $this->hasMany('Criterion', 'ChallengeCriterion');
    }

}