<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('estates', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('estates', function(Blueprint $table) {
			$table->foreign('estate_owner_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('estates', function(Blueprint $table) {
			$table->foreign('estate_manager_id')->references('id')->on('estate_manager')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('estate_manager', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('banks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('estate_manager', function(Blueprint $table) {
			$table->foreign('subtype_id')->references('id')->on('sub_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('estate_manager', function(Blueprint $table) {
			$table->foreign('marketer_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('estate_manager', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->foreign('estate_id')->references('id')->on('estates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('estate_id')->references('id')->on('estates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('renter_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('payment_methods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('estate_id')->references('id')->on('estates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services_requests', function(Blueprint $table) {
			$table->foreign('estate_id')->references('id')->on('estates')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services_requests', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services_requests', function(Blueprint $table) {
			$table->foreign('renter_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('services_requests', function(Blueprint $table) {
			$table->foreign('service_provider_id')->references('id')->on('service_providers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_providers', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('service_providers', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sub_type_features', function(Blueprint $table) {
			$table->foreign('sub_type_id')->references('id')->on('sub_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('estates', function(Blueprint $table) {
			$table->dropForeign('estates_city_id_foreign');
		});
		Schema::table('estates', function(Blueprint $table) {
			$table->dropForeign('estates_estate_owner_id_foreign');
		});
		Schema::table('estates', function(Blueprint $table) {
			$table->dropForeign('estates_estate_manager_id_foreign');
		});
		Schema::table('estate_manager', function(Blueprint $table) {
			$table->dropForeign('estate_manager_bank_id_foreign');
		});
		Schema::table('estate_manager', function(Blueprint $table) {
			$table->dropForeign('estate_manager_subtype_id_foreign');
		});
		Schema::table('estate_manager', function(Blueprint $table) {
			$table->dropForeign('estate_manager_marketer_id_foreign');
		});
		Schema::table('estate_manager', function(Blueprint $table) {
			$table->dropForeign('estate_manager_package_id_foreign');
		});
		Schema::table('units', function(Blueprint $table) {
			$table->dropForeign('units_estate_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_estate_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_renter_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_unit_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_payment_method_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_estate_id_foreign');
		});
		Schema::table('services_requests', function(Blueprint $table) {
			$table->dropForeign('services_requests_estate_id_foreign');
		});
		Schema::table('services_requests', function(Blueprint $table) {
			$table->dropForeign('services_requests_unit_id_foreign');
		});
		Schema::table('services_requests', function(Blueprint $table) {
			$table->dropForeign('services_requests_renter_id_foreign');
		});
		Schema::table('services_requests', function(Blueprint $table) {
			$table->dropForeign('services_requests_service_provider_id_foreign');
		});
		Schema::table('service_providers', function(Blueprint $table) {
			$table->dropForeign('service_providers_service_id_foreign');
		});
		Schema::table('service_providers', function(Blueprint $table) {
			$table->dropForeign('service_providers_city_id_foreign');
		});
		Schema::table('sub_type_features', function(Blueprint $table) {
			$table->dropForeign('sub_type_features_sub_type_id_foreign');
		});
	}
}