<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonTable extends Migration {

	public function up()
	{
		Schema::create('person', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('team')->unsigned();
			$table->string('image', 191);
			$table->string('name', 191);
			$table->string('position', 191);
			$table->string('qualification', 191);
			$table->text('desc');
		});
	}

	public function down()
	{
		Schema::drop('person');
	}
}