<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->date('date');
			$table->string('title');
			$table->string('short_title');
			$table->bigInteger('project_id')->unsigned();
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}