<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('project_name');
			$table->string('short_location');
			$table->string('summary');
			$table->text('description');
			$table->string('banner_img');
			$table->string('banner_thumb');
			$table->string('map_geo');
			$table->string('size');
			$table->string('location');
			$table->string('ownership');
			$table->string('status');
			$table->string('output');
			$table->text('overview');
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}