<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('project_timeline', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('construction', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('subcrible', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('project_question', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('downloads', function(Blueprint $table) {
			$table->foreign('id_project')->references('id')->on('projects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('benefits', function(Blueprint $table) {
			$table->foreign('home')->references('id')->on('home')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('howitworks', function(Blueprint $table) {
			$table->foreign('home')->references('id')->on('home')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('overview_tech', function(Blueprint $table) {
			$table->foreign('technology')->references('id')->on('technology')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comparison', function(Blueprint $table) {
			$table->foreign('technology')->references('id')->on('technology')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('person', function(Blueprint $table) {
			$table->foreign('team')->references('id')->on('team')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('project_timeline', function(Blueprint $table) {
			$table->dropForeign('project_timeline_project_id_foreign');
		});
		Schema::table('construction', function(Blueprint $table) {
			$table->dropForeign('construction_project_id_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_project_id_foreign');
		});
		Schema::table('subcrible', function(Blueprint $table) {
			$table->dropForeign('subcrible_project_id_foreign');
		});
		Schema::table('project_question', function(Blueprint $table) {
			$table->dropForeign('project_question_project_id_foreign');
		});
		Schema::table('downloads', function(Blueprint $table) {
			$table->dropForeign('downloads_id_project_foreign');
		});
		Schema::table('benefits', function(Blueprint $table) {
			$table->dropForeign('benefits_home_foreign');
		});
		Schema::table('howitworks', function(Blueprint $table) {
			$table->dropForeign('howitworks_home_foreign');
		});
		Schema::table('overview_tech', function(Blueprint $table) {
			$table->dropForeign('overview_tech_technology_foreign');
		});
		Schema::table('comparison', function(Blueprint $table) {
			$table->dropForeign('comparison_technology_foreign');
		});
		Schema::table('person', function(Blueprint $table) {
			$table->dropForeign('person_team_foreign');
		});
	}
}