<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFamilyMemberTable extends Migration {

	public function up()
	{
		Schema::create('family_member', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('pernr');
			$table->string('name', 100);
			$table->integer('family_id')->unique();
			$table->integer('family_type')->nullable();
			$table->string('family_type_desc', 50);
			$table->string('kk_no', 100)->nullable();
			$table->string('fullname', 225);
			$table->integer('gender');
			$table->date('birthday')->nullable();
			$table->string('birthplace', 100)->nullable();
			$table->integer('religion')->nullable();
			$table->string('job_title', 225)->nullable();
			$table->integer('created_by');
			$table->integer('updated_by');
		});
	}

	public function down()
	{
		Schema::drop('family_member');
	}
}