<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Teachers', function(Blueprint $table) {
			$table->foreign('specialization_id')->references('id')->on('Specializations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Teachers', function(Blueprint $table) {
			$table->foreign('gender_id')->references('id')->on('Genders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Students', function(Blueprint $table) {
			$table->foreign('gender_id')->references('id')->on('Genders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Program_Types', function(Blueprint $table) {
			$table->foreign('program_id')->references('id')->on('Programs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Classrooms', function(Blueprint $table) {
			$table->foreign('programType_id')->references('id')->on('Program_Types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Classroom_Student', function(Blueprint $table) {
			$table->foreign('classroom_id')->references('id')->on('Classrooms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Classroom_Student', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('Students')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Classroom_Teacher', function(Blueprint $table) {
			$table->foreign('classroom_id')->references('id')->on('Classrooms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Classroom_Teacher', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('Teachers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Registrations', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('Students')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Registrations', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('Teachers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Registrations', function(Blueprint $table) {
			$table->foreign('classroom_id')->references('id')->on('Classrooms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Registrations', function(Blueprint $table) {
			$table->foreign('program_id')->references('id')->on('Programs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Registrations', function(Blueprint $table) {
			$table->foreign('programType_id')->references('id')->on('Program_Types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Invoices', function(Blueprint $table) {
			$table->foreign('registration_id')->references('id')->on('Registrations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('Students')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('classroom_id')->references('id')->on('Classrooms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('Teachers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('Teachers', function(Blueprint $table) {
			$table->dropForeign('Teachers_specialization_id_foreign');
		});
		Schema::table('Teachers', function(Blueprint $table) {
			$table->dropForeign('Teachers_gender_id_foreign');
		});
		Schema::table('Students', function(Blueprint $table) {
			$table->dropForeign('Students_gender_id_foreign');
		});
		Schema::table('Program_Types', function(Blueprint $table) {
			$table->dropForeign('Program_Types_program_id_foreign');
		});
		Schema::table('Classrooms', function(Blueprint $table) {
			$table->dropForeign('Classrooms_programType_id_foreign');
		});
		Schema::table('Classroom_Student', function(Blueprint $table) {
			$table->dropForeign('Classroom_Student_classroom_id_foreign');
		});
		Schema::table('Classroom_Student', function(Blueprint $table) {
			$table->dropForeign('Classroom_Student_student_id_foreign');
		});
		Schema::table('Classroom_Teacher', function(Blueprint $table) {
			$table->dropForeign('Classroom_Teacher_classroom_id_foreign');
		});
		Schema::table('Classroom_Teacher', function(Blueprint $table) {
			$table->dropForeign('Classroom_Teacher_teacher_id_foreign');
		});
		Schema::table('Registrations', function(Blueprint $table) {
			$table->dropForeign('Registrations_student_id_foreign');
		});
		Schema::table('Registrations', function(Blueprint $table) {
			$table->dropForeign('Registrations_teacher_id_foreign');
		});
		Schema::table('Registrations', function(Blueprint $table) {
			$table->dropForeign('Registrations_classroom_id_foreign');
		});
		Schema::table('Registrations', function(Blueprint $table) {
			$table->dropForeign('Registrations_program_id_foreign');
		});
		Schema::table('Registrations', function(Blueprint $table) {
			$table->dropForeign('Registrations_programType_id_foreign');
		});
		Schema::table('Invoices', function(Blueprint $table) {
			$table->dropForeign('Invoices_registration_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_student_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_classroom_id_foreign');
		});
		Schema::table('attendances', function(Blueprint $table) {
			$table->dropForeign('attendances_teacher_id_foreign');
		});
	}
}