<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('Students', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('email')->unique();
			$table->string('mobile', 20);
			$table->bigInteger('gender_id')->unsigned();
			$table->string('personal_id');
			$table->integer('age');
			$table->string('address');
			$table->integer('status');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Students');
	}
}