<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionTable extends Migration {

	public function up()
	{
		Schema::create('subscription', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('status')->unsigned();
			$table->integer('user_id')->unsigned()->index();
			$table->integer('plan_id')->unsigned();
			$table->timestamp('renew_at')->nullable();
			$table->integer('renewal_count')->unsigned();
			$table->integer('price');
			$table->timestamp('first_renewed_at');
			$table->timestamp('last_renewed_at')->nullable();
			$table->timestamp('last_cancelled_at')->nullable();
			$table->timestamp('last_failed_at')->nullable();
			$table->timestamps();
			$table->string('note', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('subscription');
	}
}