<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Inventory extends Eloquent {

	protected $table = 'inventory';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function type()
	{
		return $this->belongsTo('App\Type');
	}

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function location()
	{
		return $this->morphTo();
	}

	public function invoice_lines()
	{
		return $this->morphMany('App\InvoiceLine');
	}

}