<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('factuurnummer', 31)->unique();
			$table->date('factuurdatum');
			$table->text('notitie');
			$table->boolean('betaald')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}