<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 255);
			$table->string('last_name', 255);
			$table->string('email', 255);
			$table->text('password');
			$table->string('image', 255);
			$table->string('whatsapp_phone', 255);
			$table->string('mobile_phone', 255);
			$table->string('home_phone', 255);
			$table->string('location', 255)->nullable();
			$table->decimal('latitude', 12,10)->nullable();
			$table->decimal('longitude', 12,10)->nullable();
			$table->bigInteger('city_id')->unsigned();
			$table->string('social_id');
			$table->tinyInteger('social_type');
			$table->tinyInteger('status')->default('0');
			$table->string('pin_code');
			$table->tinyInteger('is_verified')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}