<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCarsTable extends Migration {

	public function up()
	{
		Schema::create('cars', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('admin_id');
			$table->bigInteger('city_id');
			$table->bigInteger('showroom_id')->unsigned()->nullable();
			$table->bigInteger('user_id')->unsigned();
			$table->string('title', 255);
			$table->bigInteger('model_id')->unsigned();
			$table->text('description');
			$table->decimal('latitude', 12,10);
			$table->tinyInteger('type')->unsigned();
			$table->float('price', 10,2);
			$table->decimal('longitude', 12,10);
			$table->string('location', 255);
			$table->string('whatsapp_phone')->nullable();
			$table->timestamps();
			$table->tinyInteger('status');
			$table->integer('stock');
		});
	}

	public function down()
	{
		Schema::drop('cars');
	}
}