<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Server extends Eloquent {

	protected $table = 'server';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_server', 'url_site', 'host_name', 'login_server', 'password_server', 'login_bdd', 'mdp_bdd', 'name_bdd', 'url_bdd', 'path_backup', 'id_user');

	public function user_server()
	{
		return $this->hasOne('App\Users', 'id');
	}

}