<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('contact_folders', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('contact_folders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact_folders', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact_folders', function(Blueprint $table) {
			$table->foreign('contact_folder_access_id')->references('id')->on('contact_folder_access')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact_lists', function(Blueprint $table) {
			$table->foreign('contact_folder_id')->references('id')->on('contact_folders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contact_lists', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('contact_folder_access_users', function(Blueprint $table) {
			$table->foreign('contact_folder_access_id')->references('id')->on('contact_folder_access')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact_list_items', function(Blueprint $table) {
			$table->foreign('contact_list_id')->references('id')->on('contact_lists')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact_list_items', function(Blueprint $table) {
			$table->foreign('contact_id')->references('id')->on('contacts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact_folder_access', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact_list_bookmarks', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact_list_bookmarks', function(Blueprint $table) {
			$table->foreign('contact_list_id')->references('id')->on('contact_lists')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contact_list_bookmarks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('contact_folders', function(Blueprint $table) {
			$table->dropForeign('contact_folders_parent_id_foreign');
		});
		Schema::table('contact_folders', function(Blueprint $table) {
			$table->dropForeign('contact_folders_created_by_foreign');
		});
		Schema::table('contact_folders', function(Blueprint $table) {
			$table->dropForeign('contact_folders_contact_folder_access_id_foreign');
		});
		Schema::table('contact_lists', function(Blueprint $table) {
			$table->dropForeign('contact_lists_contact_folder_id_foreign');
		});
		Schema::table('contact_lists', function(Blueprint $table) {
			$table->dropForeign('contact_lists_owner_id_foreign');
		});
		Schema::table('contact_folder_access_users', function(Blueprint $table) {
			$table->dropForeign('contact_folder_access_users_contact_folder_access_id_foreign');
		});
		Schema::table('contact_list_items', function(Blueprint $table) {
			$table->dropForeign('contact_list_items_contact_list_id_foreign');
		});
		Schema::table('contact_list_items', function(Blueprint $table) {
			$table->dropForeign('contact_list_items_contact_id_foreign');
		});
		Schema::table('contact_folder_access', function(Blueprint $table) {
			$table->dropForeign('contact_folder_access_company_id_foreign');
		});
		Schema::table('contact_list_bookmarks', function(Blueprint $table) {
			$table->dropForeign('contact_list_bookmarks_company_id_foreign');
		});
		Schema::table('contact_list_bookmarks', function(Blueprint $table) {
			$table->dropForeign('contact_list_bookmarks_contact_list_id_foreign');
		});
		Schema::table('contact_list_bookmarks', function(Blueprint $table) {
			$table->dropForeign('contact_list_bookmarks_user_id_foreign');
		});
	}
}