<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactListsTable extends Migration {

	public function up()
	{
		Schema::create('contact_lists', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id');
			$table->integer('contact_folder_id')->unsigned()->nullable();
			$table->integer('owner_id')->unsigned();
			$table->boolean('is_bookmarked');
			$table->string('name');
			$table->tinyInteger('type');
			$table->json('headers');
			$table->json('filters');
			$table->integer('order');
			$table->boolean('is_default')->default(0);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contact_lists');
	}
}