<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('manket_members', function(Blueprint $table) {
			$table->foreign('manket_client_id')->references('id')->on('manket_clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manket_users', function(Blueprint $table) {
			$table->foreign('manket_client_id')->references('id')->on('manket_clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manket_users', function(Blueprint $table) {
			$table->foreign('manket_company_id')->references('id')->on('manket_companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manket_companies', function(Blueprint $table) {
			$table->foreign('manket_company_type_id')->references('id')->on('manket_company_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manket_projects', function(Blueprint $table) {
			$table->foreign('manket_user_id')->references('manket_client_id')->on('manket_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manket_surveys', function(Blueprint $table) {
			$table->foreign('manket_user_id')->references('manket_client_id')->on('manket_users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manket_surveys', function(Blueprint $table) {
			$table->foreign('manket_project_id')->references('id')->on('manket_projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manket_survey_questions', function(Blueprint $table) {
			$table->foreign('manket_survey_id')->references('id')->on('manket_surveys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manket_survey_questions', function(Blueprint $table) {
			$table->foreign('manket_survey_question_type_id')->references('id')->on('manket_survey_questions_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manket_survey_questions_answers', function(Blueprint $table) {
			$table->foreign('manket_member_id')->references('manket_client_id')->on('manket_members')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manket_survey_questions_answers', function(Blueprint $table) {
			$table->foreign('manket_survey_question_id')->references('id')->on('manket_survey_questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manket_member_demographics', function(Blueprint $table) {
			$table->foreign('manket_member_id')->references('manket_client_id')->on('manket_members')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('manket_survey_question_choices', function(Blueprint $table) {
			$table->foreign('manket_survey_question_id')->references('id')->on('manket_survey_questions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('manket_members', function(Blueprint $table) {
			$table->dropForeign('manket_members_manket_client_id_foreign');
		});
		Schema::table('manket_users', function(Blueprint $table) {
			$table->dropForeign('manket_users_manket_client_id_foreign');
		});
		Schema::table('manket_users', function(Blueprint $table) {
			$table->dropForeign('manket_users_manket_company_id_foreign');
		});
		Schema::table('manket_companies', function(Blueprint $table) {
			$table->dropForeign('manket_companies_manket_company_type_id_foreign');
		});
		Schema::table('manket_projects', function(Blueprint $table) {
			$table->dropForeign('manket_projects_manket_user_id_foreign');
		});
		Schema::table('manket_surveys', function(Blueprint $table) {
			$table->dropForeign('manket_surveys_manket_user_id_foreign');
		});
		Schema::table('manket_surveys', function(Blueprint $table) {
			$table->dropForeign('manket_surveys_manket_project_id_foreign');
		});
		Schema::table('manket_survey_questions', function(Blueprint $table) {
			$table->dropForeign('manket_survey_questions_manket_survey_id_foreign');
		});
		Schema::table('manket_survey_questions', function(Blueprint $table) {
			$table->dropForeign('manket_survey_questions_manket_survey_question_type_id_foreign');
		});
		Schema::table('manket_survey_questions_answers', function(Blueprint $table) {
			$table->dropForeign('manket_survey_questions_answers_manket_member_id_foreign');
		});
		Schema::table('manket_survey_questions_answers', function(Blueprint $table) {
			$table->dropForeign('manket_survey_questions_answers_manket_survey_question_id_foreign');
		});
		Schema::table('manket_member_demographics', function(Blueprint $table) {
			$table->dropForeign('manket_member_demographics_manket_member_id_foreign');
		});
		Schema::table('manket_survey_question_choices', function(Blueprint $table) {
			$table->dropForeign('manket_survey_question_choices_manket_survey_question_id_foreign');
		});
	}
}