<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CostsCenter extends Eloquent {

	protected $table = 'cost_center';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('headquarter_id', 'code', 'name', 'abbreviation');

	public function headquarter()
	{
		return $this->belongsTo('App\Headquarter');
	}

	public function venues()
	{
		return $this->hasMany('App\Venues');
	}

	public function budgets_plans()
	{
		return $this->hasMany('App\BudgetPlan');
	}

}