<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCostCenterTable extends Migration {

	public function up()
	{
		Schema::create('cost_center', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('headquarter_id')->unsigned();
			$table->string('code', 6)->unique();
			$table->string('name', 50);
			$table->char('abbreviation', 3);
		});
	}

	public function down()
	{
		Schema::drop('cost_center');
	}
}