<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class PaymentDetails extends Model 
{

    protected $table = 'payment_details';
    public $timestamps = true;
    protected $fillable = array('image', 'user_id', 'bank_account_id', 'coupon_id', 'payment_type_id', 'address_id');

    public function getBankAccount()
    {
        return $this->belongsTo('BankAccounts', 'bamk_account_id');
    }

    public function getUser()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function getPaymentType()
    {
        return $this->belongsTo('PaymentTypes', 'payment_type_id');
    }

    public function getOrders()
    {
        return $this->hasMany('Orders');
    }

}