<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Orders extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('id', 'user_id', 'address_id', 'supplier_id', 'status_id', 'coupon_id', 'payment_id', 'number_charge');

    public function getUser()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function getUserAddress()
    {
        return $this->belongsTo('UsersAddresses', 'address_id');
    }

    public function getStore()
    {
        return $this->belongsTo('Suppliers', 'store_id');
    }

    public function getOrderStatus()
    {
        return $this->belongsTo('OrderStatus', 'status_id');
    }

    public function getCoupon()
    {
        return $this->belongsTo('Coupons', 'coupon_id');
    }

    public function getPaymentDetail()
    {
        return $this->belongsTo('PaymentDetails', 'payment_id');
    }

}