<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'Products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('category_id', 'name', 'price', 'quantity', 'notes', 'image');

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}