<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 255)->nullable();
			$table->string('last_name', 255)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('mobile', 255)->nullable();
			$table->string('company_name', 255)->nullable();
			$table->string('company_site', 255)->nullable();
			$table->enum('activated', array('supplier', 'customer'))->nullable();
			$table->string('password', 255);
			$table->integer('governorate_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}