<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEstadosTable extends Migration {

	public function up()
	{
		Schema::create('estados', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('tipo', array('pendiente-pedido', 'disponible', 'vendido'));
			$table->bigInteger('articulo_real_id')->unsigned();
			$table->integer('referencia_id')->unsigned()->nullable();
			$table->string('referencia_tipo')->nullable();
			$table->integer('fila_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('estados');
	}
}