<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDependenciaTable extends Migration {

	public function up()
	{
		Schema::create('dependencia', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nombre', 100);
			$table->string('direccion', 200);
			$table->smallInteger('turnos_max_diarios')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('dependencia');
	}
}