<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCronogramaTable extends Migration {

	public function up()
	{
		Schema::create('cronograma', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('tramite_id')->unsigned();
			$table->tinyInteger('dayofweek_odbc')->unsigned();
			$table->time('hora_desde');
			$table->time('hora_hasta');
			$table->smallInteger('frecuencia_min')->unsigned();
			$table->smallInteger('sobreturnos_max');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('cronograma');
	}
}