<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function photos()
    {
        return $this->hasMany('Photo', 'product_id');
    }

    public function attributes()
    {
        return $this->hasMany('ProductAttribute', 'product_id');
    }

    public function carts()
    {
        return $this->hasManyThrough('Cart', 'CartItem');
    }

}